/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.dictionary.selection;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import re.belv.croiseur.api.dictionary.DictionaryIdentifier;
import re.belv.croiseur.common.util.Either;
import re.belv.croiseur.impl.dictionary.selection.DictionaryComparator;
import re.belv.croiseur.impl.dictionary.selection.DictionaryProviderFilter;
import re.belv.croiseur.impl.dictionary.selection.SelectedDictionary;
import re.belv.croiseur.spi.dictionary.Dictionary;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;

public final class DictionarySelector {
    private final Collection<DictionaryProvider> dictionaryProviders;

    public DictionarySelector(Collection<DictionaryProvider> dictionaryProvidersArg) {
        this.dictionaryProviders = dictionaryProvidersArg;
    }

    private static Either<String, SelectedDictionary> noDictionaryError() {
        return Either.leftOf((Object)"No dictionary found");
    }

    private static Either<String, SelectedDictionary> ambiguousRequestError(Collection<DictionaryProvider> selectedDictionaryProviders) {
        String errorMessage = "Ambiguous request: Found matching dictionaries for several providers (" + String.valueOf(selectedDictionaryProviders) + ")";
        return Either.leftOf((Object)errorMessage);
    }

    private static Either<String, SelectedDictionary> success(DictionaryProvider dictionaryProvider, Dictionary dictionary) {
        SelectedDictionary selectedDictionary = SelectedDictionary.of(dictionaryProvider.details().name(), dictionary);
        return Either.rightOf((Object)selectedDictionary);
    }

    private static Stream<SelectedDictionary> dictionariesOf(DictionaryProvider p) {
        return p.get().stream().map(d -> SelectedDictionary.of(p.details().name(), d));
    }

    public Either<String, SelectedDictionary> select(DictionaryIdentifier dictionaryIdentifier) {
        Either result;
        Collection<DictionaryProvider> selectedDictionaryProviders = DictionaryProviderFilter.byId(dictionaryIdentifier).apply(this.dictionaryProviders);
        if (selectedDictionaryProviders.isEmpty()) {
            result = DictionarySelector.noDictionaryError();
        } else if (selectedDictionaryProviders.size() > 1) {
            result = DictionarySelector.ambiguousRequestError(selectedDictionaryProviders);
        } else {
            DictionaryProvider dictionaryProvider = selectedDictionaryProviders.iterator().next();
            Optional dictionaryOpt = dictionaryProvider.getFirst();
            result = dictionaryOpt.map(dictionary -> DictionarySelector.success(dictionaryProvider, dictionary)).orElseGet(DictionarySelector::noDictionaryError);
        }
        return result;
    }

    public List<SelectedDictionary> select(Collection<DictionaryIdentifier> ids) {
        DictionaryProviderFilter selection = ids.stream().map(DictionaryProviderFilter::byId).reduce(DictionaryProviderFilter.none(), DictionaryProviderFilter::or);
        Collection<DictionaryProvider> selectedDictionaryProviders = selection.apply(this.dictionaryProviders);
        return selectedDictionaryProviders.stream().flatMap(DictionarySelector::dictionariesOf).toList();
    }

    public Optional<SelectedDictionary> selectDefault() {
        return this.dictionaryProviders.stream().flatMap(DictionarySelector::dictionariesOf).min(Comparator.comparing(SelectedDictionary::details, new DictionaryComparator()));
    }
}

