/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.puzzle.importer;

import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.impl.puzzle.persistence.shared.SafePuzzleRepository;
import re.belv.croiseur.spi.presenter.puzzle.PuzzlePresenter;
import re.belv.croiseur.spi.puzzle.codec.PuzzleDecoder;
import re.belv.croiseur.spi.puzzle.codec.PuzzleDecodingException;

final class ImportPuzzleUsecase {
    private final Collection<PuzzleDecoder> decoders;
    private final SafePuzzleRepository repository;
    private final PuzzlePresenter presenter;

    ImportPuzzleUsecase(Collection<PuzzleDecoder> decodersArg, SafePuzzleRepository repositoryArg, PuzzlePresenter presenterArg) {
        this.decoders = decodersArg;
        this.repository = repositoryArg;
        this.presenter = presenterArg;
    }

    void process(String format, InputStream inputStream) {
        Optional<PuzzleDecoder> selectedDecoder = this.selectDecoder(format);
        if (selectedDecoder.isEmpty()) {
            this.presenter.presentPuzzleImportError("No suitable decoder found for format '" + format + "'");
            return;
        }
        try {
            Puzzle puzzle = selectedDecoder.get().decode(inputStream);
            this.repository.create(puzzle);
        }
        catch (PuzzleDecodingException e) {
            this.presenter.presentPuzzleImportError("Error while importing puzzle: " + e.getMessage());
        }
    }

    private Optional<PuzzleDecoder> selectDecoder(String format) {
        return this.decoders.stream().filter(decoder -> decoder.details().supportedFormats().contains(format)).findFirst();
    }
}

