/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.puzzle.persistence;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import re.belv.croiseur.api.puzzle.persistence.PuzzlePatch;
import re.belv.croiseur.common.puzzle.ChangedPuzzle;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.common.puzzle.PuzzleClues;
import re.belv.croiseur.common.puzzle.PuzzleDetails;
import re.belv.croiseur.common.puzzle.PuzzleGrid;
import re.belv.croiseur.common.puzzle.SavedPuzzle;
import re.belv.croiseur.impl.puzzle.persistence.shared.SafePuzzleRepository;
import re.belv.croiseur.spi.presenter.puzzle.PuzzlePresenter;

final class PatchAndSavePuzzleUsecase {
    private final SafePuzzleRepository repository;
    private final PuzzlePresenter presenter;

    PatchAndSavePuzzleUsecase(SafePuzzleRepository repositoryArg, PuzzlePresenter presenterArg) {
        this.presenter = presenterArg;
        this.repository = repositoryArg;
    }

    void process(long id, PuzzlePatch patch) {
        Optional<SavedPuzzle> optSavedPuzzle = this.repository.query(id);
        if (optSavedPuzzle.isEmpty()) {
            this.presenter.presentPuzzleRepositoryError("Failed to update puzzle: Cannot find saved puzzle with id " + id);
            return;
        }
        ChangedPuzzle changedPuzzle = PatchAndSavePuzzleUsecase.patch(patch, optSavedPuzzle.get());
        this.repository.update(changedPuzzle);
    }

    private static ChangedPuzzle patch(PuzzlePatch modification, SavedPuzzle savedPuzzle) {
        PuzzleDetails details = PatchAndSavePuzzleUsecase.patch(savedPuzzle.details(), modification);
        PuzzleGrid grid = modification.modifiedGrid().orElseGet(() -> ((SavedPuzzle)savedPuzzle).grid());
        PuzzleClues clues = PatchAndSavePuzzleUsecase.patch(savedPuzzle.clues(), modification);
        Puzzle modifiedPuzzleData = new Puzzle(details, grid, clues);
        return savedPuzzle.modifiedWith(modifiedPuzzleData);
    }

    private static PuzzleDetails patch(PuzzleDetails original, PuzzlePatch patch) {
        String title = patch.modifiedTitle().orElseGet(() -> ((PuzzleDetails)original).title());
        String author = patch.modifiedAuthor().orElseGet(() -> ((PuzzleDetails)original).author());
        String editor = patch.modifiedEditor().orElseGet(() -> ((PuzzleDetails)original).editor());
        String copyright = patch.modifiedCopyright().orElseGet(() -> ((PuzzleDetails)original).copyright());
        Optional<LocalDate> date = patch.modifiedDate().or(() -> ((PuzzleDetails)original).date());
        return new PuzzleDetails(title, author, editor, copyright, date);
    }

    private static PuzzleClues patch(PuzzleClues original, PuzzlePatch patch) {
        List acrossClues = patch.modifiedAcrossClues().orElseGet(() -> ((PuzzleClues)original).across());
        List downClues = patch.modifiedDownClues().orElseGet(() -> ((PuzzleClues)original).down());
        return new PuzzleClues(acrossClues, downClues);
    }
}

