/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.solver;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import re.belv.croiseur.spi.presenter.solver.SolverDescription;
import re.belv.croiseur.spi.presenter.solver.SolverPresenter;
import re.belv.croiseur.spi.solver.CrosswordSolver;

final class ListSolversUsecase {
    private final List<SolverDescription> solvers;
    private final SolverPresenter presenter;

    ListSolversUsecase(Collection<CrosswordSolver> solversArg, SolverPresenter presenterArg) {
        this.solvers = solversArg.stream().map(solver -> new SolverDescription(solver.name(), solver.description())).sorted(Comparator.comparing(SolverDescription::name, new SolverNameComparator())).toList();
        this.presenter = presenterArg;
    }

    void process() {
        if (this.solvers.isEmpty()) {
            this.presenter.presentSolverError("No solver found");
        } else {
            this.presenter.presentAvailableSolvers(this.solvers);
        }
    }

    private static final class SolverNameComparator
    implements Comparator<String> {
        private static final String PREFERRED_SOLVER = "Ginsberg";

        SolverNameComparator() {
        }

        @Override
        public int compare(String a, String b) {
            int result = PREFERRED_SOLVER.equals(a) ? (PREFERRED_SOLVER.equals(b) ? 0 : -1) : (PREFERRED_SOLVER.equals(b) ? 1 : a.compareTo(b));
            return result;
        }
    }
}

