/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.solver;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import re.belv.croiseur.api.solver.SolveRequest;
import re.belv.croiseur.common.puzzle.ChangedPuzzle;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.common.puzzle.PuzzleClues;
import re.belv.croiseur.common.puzzle.PuzzleDetails;
import re.belv.croiseur.common.puzzle.PuzzleGrid;
import re.belv.croiseur.common.puzzle.SavedPuzzle;
import re.belv.croiseur.impl.clue.shared.SafeClueProvider;
import re.belv.croiseur.impl.puzzle.persistence.shared.SafePuzzleRepository;
import re.belv.croiseur.impl.solver.postrun.SolverResultConverter;
import re.belv.croiseur.impl.solver.prerun.DictionaryLoader;
import re.belv.croiseur.impl.solver.prerun.ProgressListenerFactory;
import re.belv.croiseur.impl.solver.prerun.ShuffledSolverDictionary;
import re.belv.croiseur.spi.clue.ClueProvider;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;
import re.belv.croiseur.spi.presenter.Presenter;
import re.belv.croiseur.spi.presenter.clue.CluePresenter;
import re.belv.croiseur.spi.presenter.puzzle.PuzzlePresenter;
import re.belv.croiseur.spi.presenter.solver.SolverPresenter;
import re.belv.croiseur.spi.puzzle.repository.PuzzleRepository;
import re.belv.croiseur.spi.solver.CrosswordSolver;
import re.belv.croiseur.spi.solver.Dictionary;
import re.belv.croiseur.spi.solver.ProgressListener;
import re.belv.croiseur.spi.solver.SolverResult;

final class SolveUsecase {
    private final Map<String, CrosswordSolver> solvers;
    private final DictionaryLoader dictionaryLoader;
    private final SafeClueProvider clueProvider;
    private final SafePuzzleRepository puzzleRepository;
    private final Presenter presenter;
    private final ProgressListenerFactory progressListenerFactory;

    SolveUsecase(Collection<CrosswordSolver> solversArg, Collection<DictionaryProvider> dictionaryProvidersArg, Collection<ClueProvider> clueProvidersArg, PuzzleRepository puzzleRepositoryArg, Presenter presenterArg) {
        this.solvers = solversArg.stream().collect(Collectors.toMap(CrosswordSolver::name, Function.identity()));
        this.clueProvider = new SafeClueProvider(clueProvidersArg, (CluePresenter)presenterArg);
        this.puzzleRepository = new SafePuzzleRepository(puzzleRepositoryArg, (PuzzlePresenter)presenterArg);
        this.dictionaryLoader = new DictionaryLoader(dictionaryProvidersArg);
        this.progressListenerFactory = new ProgressListenerFactory((SolverPresenter)presenterArg);
        this.presenter = presenterArg;
    }

    void process(SolveRequest event) {
        Optional<CrosswordSolver> optSolver = this.selectSolver(event);
        if (optSolver.isEmpty()) {
            this.presenter.presentSolverError("Solver not found");
            return;
        }
        Optional<Dictionary> optDictionary = this.dictionaryLoader.load(event.dictionaries());
        if (optDictionary.isEmpty()) {
            this.presenter.presentSolverError("Dictionary not found");
            return;
        }
        Optional<SavedPuzzle> savedPuzzle = this.optionallySavePuzzle(event);
        Dictionary dictionary = SolveUsecase.optionallyShuffledDictionary(event, optDictionary.get());
        ProgressListener progressListener = this.progressListenerFactory.from(event.progress());
        Optional<SolverResult> optResult = this.runSolver(optSolver.get(), event.grid(), dictionary, progressListener);
        if (optResult.isPresent()) {
            SolverResult solverResult = optResult.get();
            re.belv.croiseur.spi.presenter.solver.SolverResult presentableResult = SolverResultConverter.toPresentable(solverResult, event.grid());
            this.presenter.presentSolverResult(presentableResult);
            Map<String, String> clues = this.optionallyGetClues(event, presentableResult);
            this.optionallyPresentClues(clues);
            this.optionallyUpdateSavedPuzzle(savedPuzzle, presentableResult, clues);
        }
    }

    private Optional<CrosswordSolver> selectSolver(SolveRequest request) {
        return request.solver().map(this.solvers::get).or(this.solvers.values().stream()::findFirst);
    }

    private Optional<SavedPuzzle> optionallySavePuzzle(SolveRequest solveRequest) {
        if (!solveRequest.savePuzzle()) {
            return Optional.empty();
        }
        Puzzle puzzleToSave = new Puzzle(PuzzleDetails.emptyOfToday(), solveRequest.grid(), PuzzleClues.empty());
        return this.puzzleRepository.create(puzzleToSave);
    }

    private static Dictionary optionallyShuffledDictionary(SolveRequest event, Dictionary dictionary) {
        return event.dictionariesShuffle().map(random -> new ShuffledSolverDictionary(dictionary, (Random)random)).orElse(dictionary);
    }

    private Optional<SolverResult> runSolver(CrosswordSolver solver, PuzzleGrid puzzle, Dictionary dictionary, ProgressListener progressListener) {
        try {
            SolverResult result = solver.solve(puzzle, dictionary, progressListener);
            return Optional.of(result);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
        catch (Exception e) {
            this.presenter.presentSolverError(e.getMessage());
            return Optional.empty();
        }
    }

    private Map<String, String> optionallyGetClues(SolveRequest event, re.belv.croiseur.spi.presenter.solver.SolverResult presentableResult) {
        Map<String, String> clues;
        if (event.withClues() && presentableResult.isSuccess()) {
            Set words = presentableResult.grid().slotContents();
            clues = this.clueProvider.getClues(words);
        } else {
            clues = Collections.emptyMap();
        }
        return clues;
    }

    private void optionallyPresentClues(Map<String, String> clues) {
        if (!clues.isEmpty()) {
            this.presenter.presentClues(clues);
        }
    }

    private void optionallyUpdateSavedPuzzle(Optional<SavedPuzzle> savedPuzzleOpt, re.belv.croiseur.spi.presenter.solver.SolverResult presentableResult, Map<String, String> clues) {
        if (savedPuzzleOpt.isPresent() && presentableResult.isSuccess()) {
            SavedPuzzle savedPuzzle = savedPuzzleOpt.get();
            PuzzleGrid newGrid = presentableResult.grid();
            PuzzleClues newClues = PuzzleClues.from(clues, (PuzzleGrid)newGrid);
            ChangedPuzzle changedPuzzle = savedPuzzle.modifiedWith(newGrid, newClues);
            this.puzzleRepository.update(changedPuzzle);
        }
    }
}

