/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.solver.prerun;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import re.belv.croiseur.api.dictionary.DictionaryIdentifier;
import re.belv.croiseur.impl.dictionary.selection.DictionarySelector;
import re.belv.croiseur.impl.dictionary.selection.SelectedDictionary;
import re.belv.croiseur.impl.solver.prerun.CompositeSolverDictionary;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;
import re.belv.croiseur.spi.solver.Dictionary;

public final class DictionaryLoader {
    private final DictionarySelector selector;

    public DictionaryLoader(Collection<DictionaryProvider> dictionaryProvidersArg) {
        this.selector = new DictionarySelector(dictionaryProvidersArg);
    }

    public Optional<Dictionary> load(Collection<DictionaryIdentifier> dictionaries) {
        List selectedDictionaries = dictionaries.isEmpty() ? this.selector.selectDefault().map(Collections::singletonList).orElseGet(Collections::emptyList) : this.selector.select(dictionaries);
        if (selectedDictionaries.isEmpty()) {
            return Optional.empty();
        }
        List<Dictionary> selectedSolverDictionaries = selectedDictionaries.stream().map(this::toSolverDictionary).toList();
        return Optional.of(new CompositeSolverDictionary(selectedSolverDictionaries));
    }

    private Dictionary toSolverDictionary(SelectedDictionary dictionary) {
        return dictionary::words;
    }
}

