/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.solver.prerun;

import java.util.EnumMap;
import java.util.Map;
import re.belv.croiseur.api.solver.SolveRequest;
import re.belv.croiseur.spi.presenter.solver.SolverInitialisationState;
import re.belv.croiseur.spi.presenter.solver.SolverPresenter;
import re.belv.croiseur.spi.presenter.solver.SolverProgress;
import re.belv.croiseur.spi.solver.ProgressListener;

public final class ProgressListenerFactory {
    private final Map<SolveRequest.SolverProgressNotificationMethod, ProgressListener> listeners = new EnumMap<SolveRequest.SolverProgressNotificationMethod, ProgressListener>(SolveRequest.SolverProgressNotificationMethod.class);

    public ProgressListenerFactory(SolverPresenter solverPresenterArg) {
        this.listeners.put(SolveRequest.SolverProgressNotificationMethod.NONE, ProgressListener.DUMMY_LISTENER);
        this.listeners.put(SolveRequest.SolverProgressNotificationMethod.PERIODICAL, new ProgressListenerImpl(solverPresenterArg));
    }

    public ProgressListener from(SolveRequest.SolverProgressNotificationMethod kind) {
        return this.listeners.get((Object)kind);
    }

    private static final class ProgressListenerImpl
    implements ProgressListener {
        private final SolverPresenter presenter;

        ProgressListenerImpl(SolverPresenter presenterArg) {
            this.presenter = presenterArg;
        }

        public void onInitialisationStart() {
            this.presenter.presentSolverInitialisationState(SolverInitialisationState.STARTED);
        }

        public void onInitialisationEnd() {
            this.presenter.presentSolverInitialisationState(SolverInitialisationState.ENDED);
        }

        public void onSolverProgressUpdate(short completionPercentage) {
            this.presenter.presentSolverProgress(new SolverProgress(completionPercentage));
        }
    }
}

