/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model;

public record GridCoord(int column, int row) {
    public GridCoord {
        if (column < 0 || row < 0) {
            throw new IllegalArgumentException("Invalid grid position");
        }
    }

    public static GridCoord at(int x, int y) {
        return new GridCoord(x, y);
    }

    public GridCoord down() {
        return this.plusVerticalOffset(1);
    }

    public GridCoord up() {
        return this.plusVerticalOffset(-1);
    }

    public GridCoord right() {
        return this.plusHorizontalOffset(1);
    }

    public GridCoord left() {
        return this.plusHorizontalOffset(-1);
    }

    public GridCoord plusHorizontalOffset(int offset) {
        return new GridCoord(Math.max(0, this.column + offset), this.row);
    }

    public GridCoord plusVerticalOffset(int offset) {
        return new GridCoord(this.column, Math.max(0, this.row + offset));
    }

    @Override
    public String toString() {
        return "GridCoord{column=" + this.column + ", row=" + this.row + "}";
    }
}

