/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model;

import java.util.Iterator;
import java.util.stream.IntStream;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import re.belv.croiseur.gui.view.model.SavedPuzzleViewModel;

public final class PuzzleSelectionViewModel {
    private final ListProperty<SavedPuzzleViewModel> availablePuzzles = new SimpleListProperty((Object)this, "availablePuzzles", FXCollections.observableArrayList());
    private final ObjectProperty<SavedPuzzleViewModel> selectedPuzzle = new SimpleObjectProperty((Object)this, "selectedPuzzle");

    PuzzleSelectionViewModel() {
    }

    public ListProperty<SavedPuzzleViewModel> availablePuzzlesProperty() {
        return this.availablePuzzles;
    }

    public void updateAvailablePuzzlesWith(SavedPuzzleViewModel puzzle) {
        IntStream.range(0, this.availablePuzzles.size()).filter(i -> ((SavedPuzzleViewModel)this.availablePuzzles.get(i)).id() == puzzle.id()).findFirst().ifPresentOrElse(i -> this.availablePuzzles.set(i, (Object)puzzle), () -> this.availablePuzzles.add((Object)puzzle));
    }

    public void removeAvailablePuzzleWithId(long id) {
        Iterator puzzleIt = this.availablePuzzles.iterator();
        while (puzzleIt.hasNext()) {
            SavedPuzzleViewModel puzzle = (SavedPuzzleViewModel)puzzleIt.next();
            if (puzzle.id() != id) continue;
            puzzleIt.remove();
            break;
        }
    }

    public ObjectProperty<SavedPuzzleViewModel> selectedPuzzleProperty() {
        return this.selectedPuzzle;
    }

    public SavedPuzzleViewModel selectedPuzzle() {
        return (SavedPuzzleViewModel)this.selectedPuzzle.get();
    }

    public void selectedPuzzle(SavedPuzzleViewModel savedPuzzle) {
        this.selectedPuzzle.set((Object)savedPuzzle);
    }
}

