/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model.slot;

import java.util.List;
import java.util.ListIterator;
import re.belv.croiseur.gui.view.model.slot.ColumnCountChangeProcessor;
import re.belv.croiseur.gui.view.model.slot.RowCountChangeProcessor;
import re.belv.croiseur.gui.view.model.slot.SlotOutline;

abstract sealed class DimensionChangeProcessor
permits ColumnCountChangeProcessor, RowCountChangeProcessor {
    private final List<SlotOutline> collinearSlots;
    private final List<SlotOutline> orthogonalSlots;

    DimensionChangeProcessor(List<SlotOutline> collinearSlotsArg, List<SlotOutline> orthogonalSlotsArg) {
        this.collinearSlots = collinearSlotsArg;
        this.orthogonalSlots = orthogonalSlotsArg;
    }

    final void process(int oldLength, int newLength, int otherDimensionLength) {
        if (newLength == 0) {
            this.collinearSlots.clear();
            this.orthogonalSlots.clear();
            return;
        }
        if (oldLength > newLength) {
            this.collinearSlots.removeIf(slot -> slot.offset >= newLength);
        } else {
            for (int row = oldLength; row < newLength; ++row) {
                this.collinearSlots.add(this.collinearSlotOf(0, otherDimensionLength, row));
            }
        }
        ListIterator<SlotOutline> it = this.orthogonalSlots.listIterator();
        while (it.hasNext()) {
            SlotOutline slot2 = it.next();
            if (slot2.end < oldLength && slot2.end < newLength) continue;
            if (slot2.start < newLength) {
                it.set(this.orthogonalSlotOf(slot2.start, newLength, slot2.offset));
                continue;
            }
            it.remove();
        }
    }

    abstract SlotOutline collinearSlotOf(int var1, int var2, int var3);

    abstract SlotOutline orthogonalSlotOf(int var1, int var2, int var3);
}

