/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.common.util;

import java.util.NoSuchElementException;
import java.util.Objects;

public final class Either<L, R> {
    private final L left;
    private final R right;

    private Either(L leftArg, R rightArg) {
        this.left = leftArg;
        this.right = rightArg;
    }

    public static <L, R> Either<L, R> leftOf(L left) {
        Objects.requireNonNull(left);
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> rightOf(R right) {
        Objects.requireNonNull(right);
        return new Either<Object, R>(null, right);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return !this.isLeft();
    }

    public L left() {
        if (!this.isLeft()) {
            throw new NoSuchElementException();
        }
        return this.left;
    }

    public R right() {
        if (!this.isRight()) {
            throw new NoSuchElementException();
        }
        return this.right;
    }
}

