/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javafx.application.Application;
import javafx.application.ColorScheme;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import re.belv.croiseur.api.CrosswordService;
import re.belv.croiseur.gui.CrosswordEditorController;
import re.belv.croiseur.gui.CrosswordServiceLoader;
import re.belv.croiseur.gui.SceneSwitcher;
import re.belv.croiseur.gui.ViewLoader;
import re.belv.croiseur.gui.WelcomeScreenController;
import re.belv.croiseur.gui.concurrent.MoreExecutors;
import re.belv.croiseur.gui.presenter.GuiPresenter;
import re.belv.croiseur.gui.view.model.ApplicationViewModel;
import re.belv.croiseur.gui.view.model.ErrorsViewModel;
import re.belv.croiseur.spi.presenter.Presenter;

public final class CroiseurGuiApplication
extends Application {
    private static final String STAGE_TITLE = "Croiseur";
    private static final int MIN_WIDTH = 510;
    private static final int MIN_HEIGHT = 400;
    private static final String ICON_NAME = "application-icon.png";
    private static final Map<ColorScheme, String> STYLESHEETS = Map.of(ColorScheme.LIGHT, "theme-light.css", ColorScheme.DARK, "theme-dark.css");
    private static final int NUMBER_OF_BACKGROUND_THREADS = 2;
    private final Collection<AutoCloseable> resources = new ArrayList<AutoCloseable>();

    public void start(Stage stage) throws IOException {
        SceneSwitcher sceneSwitcher = new SceneSwitcher(stage);
        Executor executor = this.createExecutor();
        CroiseurGuiApplication.loadComponents(stage, sceneSwitcher, executor);
        CroiseurGuiApplication.configureStage(stage);
        CroiseurGuiApplication.configureStyleSheets();
        stage.show();
    }

    public void stop() throws Exception {
        for (AutoCloseable resource : this.resources) {
            resource.close();
        }
    }

    private static void configureStage(Stage stage) {
        stage.setTitle(STAGE_TITLE);
        stage.setMinWidth(510.0);
        stage.setMinHeight(400.0);
        Image icon = CroiseurGuiApplication.loadIcon();
        stage.getIcons().add((Object)icon);
        stage.setOnCloseRequest(event -> Platform.exit());
    }

    private static Image loadIcon() {
        InputStream iconLocation = CroiseurGuiApplication.class.getResourceAsStream(ICON_NAME);
        Objects.requireNonNull(iconLocation, "Application icon not found");
        return new Image(iconLocation);
    }

    private static void configureStyleSheets() {
        Platform.Preferences prefs = Platform.getPreferences();
        CroiseurGuiApplication.setStyleSheet(prefs.getColorScheme());
        prefs.colorSchemeProperty().addListener((ignoredObservable, ignoredOldScheme, newScheme) -> CroiseurGuiApplication.setStyleSheet(newScheme));
    }

    private static void setStyleSheet(ColorScheme scheme) {
        String styleSheet = STYLESHEETS.get(scheme);
        URL styleSheetUrl = CroiseurGuiApplication.class.getResource(styleSheet);
        Objects.requireNonNull(styleSheetUrl, () -> "Application stylesheet " + styleSheet + " not found");
        CroiseurGuiApplication.setUserAgentStylesheet((String)styleSheetUrl.toString());
    }

    private static void loadComponents(Stage stage, SceneSwitcher sceneSwitcher, Executor executor) throws IOException {
        ApplicationViewModel applicationViewModel = new ApplicationViewModel();
        CroiseurGuiApplication.loadErrorPopup(applicationViewModel.errorsViewModel(), stage);
        GuiPresenter presenter = new GuiPresenter(applicationViewModel);
        CrosswordService crosswordService = CrosswordServiceLoader.load((Presenter)presenter);
        CroiseurGuiApplication.loadWelcomeScreen(applicationViewModel, crosswordService, sceneSwitcher, executor);
        CroiseurGuiApplication.loadCrosswordEditor(applicationViewModel, crosswordService, sceneSwitcher, executor);
    }

    private static void loadErrorPopup(ErrorsViewModel errorsViewModel, Stage stage) {
        errorsViewModel.currentErrorProperty().addListener((observable, oldError, newError) -> {
            if (newError != null) {
                Alert errorAlert = new Alert(Alert.AlertType.ERROR, newError, new ButtonType[0]);
                errorAlert.initOwner(stage.getScene().getWindow());
                errorAlert.showAndWait();
                errorsViewModel.acknowledgeError();
            }
        });
    }

    private static void loadWelcomeScreen(ApplicationViewModel applicationViewModel, CrosswordService crosswordService, SceneSwitcher sceneSwitcher, Executor executor) throws IOException {
        WelcomeScreenController welcomeScreenController = new WelcomeScreenController(applicationViewModel.puzzleSelectionViewModel(), applicationViewModel.puzzleEditionViewModel(), applicationViewModel.puzzleCodecsViewModel(), crosswordService.puzzleService(), sceneSwitcher, executor);
        Parent parent = (Parent)ViewLoader.load(welcomeScreenController);
        sceneSwitcher.registerScene(SceneSwitcher.SceneId.WELCOME_SCREEN, new Scene(parent));
    }

    private static void loadCrosswordEditor(ApplicationViewModel applicationViewModel, CrosswordService crosswordService, SceneSwitcher sceneSwitcher, Executor executor) throws IOException {
        CrosswordEditorController editorController = new CrosswordEditorController(crosswordService, applicationViewModel, sceneSwitcher, executor);
        Parent parent = (Parent)ViewLoader.load(editorController);
        sceneSwitcher.registerScene(SceneSwitcher.SceneId.CROSSWORD_EDITOR, new Scene(parent));
    }

    private Executor createExecutor() {
        ExecutorService executor = MoreExecutors.newQuickClosureFixedThreadPool(2);
        this.resources.add(executor);
        return executor;
    }
}

