/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui;

import java.util.EnumMap;
import java.util.Map;
import javafx.scene.Scene;
import javafx.stage.Stage;

final class SceneSwitcher {
    private final Stage stage;
    private final Map<SceneId, Scene> scenes;

    SceneSwitcher(Stage stageArg) {
        this.stage = stageArg;
        this.stage.setScene(null);
        this.scenes = new EnumMap<SceneId, Scene>(SceneId.class);
    }

    void registerScene(SceneId sceneId, Scene scene) {
        this.scenes.put(sceneId, scene);
        if (this.stage.getScene() == null) {
            this.stage.setScene(scene);
        }
    }

    void switchToWelcomeScreen() {
        this.switchTo(SceneId.WELCOME_SCREEN);
    }

    void switchToEditorView() {
        this.switchTo(SceneId.CROSSWORD_EDITOR);
    }

    void switchTo(SceneId sceneId) {
        Scene scene = this.scenes.get((Object)sceneId);
        this.stage.setScene(scene);
    }

    static enum SceneId {
        WELCOME_SCREEN,
        CROSSWORD_EDITOR;

    }
}

