/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;

final class ViewLoader {
    private ViewLoader() {
    }

    static <T> T load(Object controller) throws IOException {
        Class<?> clazz = controller.getClass();
        String viewName = clazz.getSimpleName().replace("Controller", "View") + ".fxml";
        URL fxmlLocation = Objects.requireNonNull(clazz.getResource(viewName), "Failed to locate " + viewName);
        String resourceBundleName = clazz.getName().replace("Controller", "");
        ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceBundleName);
        FXMLLoader loader = new FXMLLoader(fxmlLocation, resourceBundle);
        loader.setControllerFactory(unusedClassParam -> controller);
        return (T)loader.load();
    }
}

