/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.concurrent;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

final class QuickClosureExecutorService
extends AbstractExecutorService {
    private static final long SHUTDOWN_TIMEOUT = 250L;
    private final ExecutorService executorService;

    QuickClosureExecutorService(ExecutorService executorServiceArg) {
        this.executorService = executorServiceArg;
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    @Override
    public void close() {
        this.shutdown();
        try {
            if (!this.awaitTermination(250L, TimeUnit.MILLISECONDS)) {
                this.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            this.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

