/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.codec.xd.plugin;

import java.io.InputStream;
import java.util.List;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.common.puzzle.PuzzleCodecDetails;
import re.belv.croiseur.puzzle.codec.xd.model.XdCrossword;
import re.belv.croiseur.puzzle.codec.xd.plugin.PuzzleConverter;
import re.belv.croiseur.puzzle.codec.xd.reader.XdCrosswordReader;
import re.belv.croiseur.puzzle.codec.xd.reader.XdReadException;
import re.belv.croiseur.spi.puzzle.codec.PuzzleDecoder;
import re.belv.croiseur.spi.puzzle.codec.PuzzleDecodingException;

public final class XdDecoder
implements PuzzleDecoder {
    private final XdCrosswordReader xd = new XdCrosswordReader();

    public PuzzleCodecDetails details() {
        return new PuzzleCodecDetails("xd", "xd format decoder", List.of("*.xd"));
    }

    public Puzzle decode(InputStream input) throws PuzzleDecodingException {
        try {
            XdCrossword xdCrossword = this.xd.read(input);
            return PuzzleConverter.toDomain(xdCrossword);
        }
        catch (XdReadException e) {
            throw new PuzzleDecodingException((Throwable)e);
        }
    }
}

