/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.presenter;

import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javafx.application.Platform;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.common.puzzle.PuzzleClues;
import re.belv.croiseur.common.puzzle.PuzzleCodecDetails;
import re.belv.croiseur.common.puzzle.PuzzleDetails;
import re.belv.croiseur.common.puzzle.PuzzleGrid;
import re.belv.croiseur.common.puzzle.SavedPuzzle;
import re.belv.croiseur.gui.view.model.CluesViewModel;
import re.belv.croiseur.gui.view.model.CrosswordBoxViewModel;
import re.belv.croiseur.gui.view.model.CrosswordGridViewModel;
import re.belv.croiseur.gui.view.model.ErrorsViewModel;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.PuzzleCodec;
import re.belv.croiseur.gui.view.model.PuzzleCodecsViewModel;
import re.belv.croiseur.gui.view.model.PuzzleDetailsViewModel;
import re.belv.croiseur.gui.view.model.PuzzleEditionViewModel;
import re.belv.croiseur.gui.view.model.PuzzleSelectionViewModel;
import re.belv.croiseur.gui.view.model.SavedPuzzleViewModel;
import re.belv.croiseur.spi.presenter.puzzle.PuzzlePresenter;

final class GuiPuzzlePresenter
implements PuzzlePresenter {
    private static final Logger LOGGER = Logger.getLogger(GuiPuzzlePresenter.class.getName());
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
    private final PuzzleSelectionViewModel puzzleSelectionViewModel;
    private final PuzzleDetailsViewModel puzzleDetailsViewModel;
    private final CrosswordGridViewModel crosswordGridViewModel;
    private final CluesViewModel cluesViewModel;
    private final PuzzleCodecsViewModel puzzleCodecsViewModel;
    private final ErrorsViewModel errorsViewModel;

    GuiPuzzlePresenter(PuzzleSelectionViewModel puzzleSelectionViewModelArg, PuzzleEditionViewModel puzzleEditionViewModelArg, PuzzleCodecsViewModel puzzleCodecsViewModelArg, ErrorsViewModel errorsViewModelArg) {
        this.puzzleSelectionViewModel = puzzleSelectionViewModelArg;
        this.puzzleDetailsViewModel = puzzleEditionViewModelArg.puzzleDetailsViewModel();
        this.crosswordGridViewModel = puzzleEditionViewModelArg.crosswordGridViewModel();
        this.cluesViewModel = puzzleEditionViewModelArg.cluesViewModel();
        this.puzzleCodecsViewModel = puzzleCodecsViewModelArg;
        this.errorsViewModel = errorsViewModelArg;
    }

    public void presentAvailablePuzzles(List<SavedPuzzle> puzzles) {
        LOGGER.info(() -> "Received available puzzles: " + String.valueOf(puzzles));
        List<SavedPuzzleViewModel> savedPuzzleViewModels = puzzles.stream().map(GuiPuzzlePresenter::convertToViewModel).toList();
        Platform.runLater(() -> this.puzzleSelectionViewModel.availablePuzzlesProperty().setAll((Collection)savedPuzzleViewModels));
    }

    public void presentLoadedPuzzle(SavedPuzzle puzzle) {
        LOGGER.info(() -> "Received loaded puzzle: " + String.valueOf(puzzle));
        Platform.runLater(() -> {
            this.fillDetailsViewModelWith(puzzle.id(), puzzle.revision(), puzzle.details());
            this.fillGridViewModelWith(puzzle.grid());
            this.fillCluesViewModelWith(puzzle.clues());
        });
    }

    public void presentPuzzleRepositoryError(String error) {
        LOGGER.warning(() -> "Received puzzle repository error: " + error);
        Platform.runLater(() -> this.errorsViewModel.addError(error));
    }

    public void presentSavedPuzzle(SavedPuzzle puzzle) {
        LOGGER.info(() -> "Received saved puzzle: " + String.valueOf(puzzle));
        SavedPuzzleViewModel savedPuzzleViewModel = GuiPuzzlePresenter.convertToViewModel(puzzle);
        Platform.runLater(() -> {
            this.puzzleSelectionViewModel.updateAvailablePuzzlesWith(savedPuzzleViewModel);
            this.puzzleDetailsViewModel.id(puzzle.id());
            this.puzzleDetailsViewModel.revision(puzzle.revision());
        });
    }

    public void presentDeletedAllPuzzles() {
        Platform.runLater(() -> this.puzzleSelectionViewModel.availablePuzzlesProperty().clear());
    }

    public void presentDeletedPuzzle(long id) {
        Platform.runLater(() -> this.puzzleSelectionViewModel.removeAvailablePuzzleWithId(id));
    }

    public void presentPuzzleDecoders(List<PuzzleCodecDetails> decoders) {
        LOGGER.info(() -> "Received puzzle decoders: " + String.valueOf(decoders));
        List<PuzzleCodec> decoderViewModels = decoders.stream().map(GuiPuzzlePresenter::convertToViewModel).toList();
        Platform.runLater(() -> this.puzzleCodecsViewModel.decodersProperty().setAll((Collection)decoderViewModels));
    }

    public void presentPuzzleImportError(String error) {
        LOGGER.warning(() -> "Received puzzle import error: " + error);
        Platform.runLater(() -> this.errorsViewModel.addError(error));
    }

    public void presentPuzzleEncoders(List<PuzzleCodecDetails> encoders) {
        LOGGER.info(() -> "Received puzzle encoders: " + String.valueOf(encoders));
        List<PuzzleCodec> encoderViewModels = encoders.stream().map(GuiPuzzlePresenter::convertToViewModel).toList();
        Platform.runLater(() -> this.puzzleCodecsViewModel.encodersProperty().setAll((Collection)encoderViewModels));
    }

    public void presentPuzzleExportError(String error) {
        LOGGER.warning(() -> "Received puzzle export error: " + error);
        Platform.runLater(() -> this.errorsViewModel.addError(error));
    }

    private static SavedPuzzleViewModel convertToViewModel(SavedPuzzle puzzle) {
        PuzzleDetails details = puzzle.details();
        SavedPuzzleViewModel.Builder builder = new SavedPuzzleViewModel.Builder().id(puzzle.id()).revision(puzzle.revision()).title(details.title()).author(details.author()).editor(details.editor()).copyright(details.copyright()).date(details.date().map(DATE_FORMATTER::format).orElse("")).numberOfColumns(puzzle.grid().width()).numberOfRows(puzzle.grid().height());
        puzzle.grid().shaded().forEach(pos -> builder.shaded(GuiPuzzlePresenter.gridCoordFrom(pos)));
        puzzle.grid().filled().forEach((pos, letter) -> builder.filled(GuiPuzzlePresenter.gridCoordFrom(pos), letter));
        return builder.build();
    }

    private static PuzzleCodec convertToViewModel(PuzzleCodecDetails codecDetails) {
        String joinedFormats = String.join((CharSequence)", ", codecDetails.supportedFormats());
        String prettyName = codecDetails.name() + " files (" + joinedFormats + ")";
        return new PuzzleCodec(prettyName, codecDetails.supportedFormats());
    }

    private void fillDetailsViewModelWith(long id, int revision, PuzzleDetails details) {
        this.puzzleDetailsViewModel.id(id);
        this.puzzleDetailsViewModel.revision(revision);
        this.puzzleDetailsViewModel.title(details.title());
        this.puzzleDetailsViewModel.author(details.author());
        this.puzzleDetailsViewModel.editor(details.editor());
        this.puzzleDetailsViewModel.copyright(details.copyright());
        details.date().map(DATE_FORMATTER::format).ifPresent(arg_0 -> ((PuzzleDetailsViewModel)this.puzzleDetailsViewModel).date(arg_0));
    }

    private void fillGridViewModelWith(PuzzleGrid grid) {
        this.crosswordGridViewModel.resizeTo(grid.width(), grid.height());
        HashSet positionsToUpdate = new HashSet(this.crosswordGridViewModel.boxesProperty().keySet());
        grid.filled().forEach((position, letter) -> {
            positionsToUpdate.remove(GuiPuzzlePresenter.gridCoordFrom(position));
            CrosswordBoxViewModel box = this.crosswordGridViewModel.box(GuiPuzzlePresenter.gridCoordFrom(position));
            box.lighten();
            box.userContent(String.valueOf(letter));
        });
        grid.shaded().forEach(position -> {
            positionsToUpdate.remove(GuiPuzzlePresenter.gridCoordFrom(position));
            this.crosswordGridViewModel.box(GuiPuzzlePresenter.gridCoordFrom(position)).shade();
        });
        positionsToUpdate.stream().map(arg_0 -> ((CrosswordGridViewModel)this.crosswordGridViewModel).box(arg_0)).forEach(box -> {
            box.lighten();
            box.userContent("");
        });
    }

    private static GridCoord gridCoordFrom(GridPosition domainPosition) {
        return new GridCoord(domainPosition.x(), domainPosition.y());
    }

    private void fillCluesViewModelWith(PuzzleClues clues) {
        List acrossClues = clues.across();
        for (int i = 0; i < acrossClues.size(); ++i) {
            this.cluesViewModel.acrossClue(i).userContent((String)acrossClues.get(i));
        }
        List downClues = clues.down();
        for (int i = 0; i < downClues.size(); ++i) {
            this.cluesViewModel.downClue(i).userContent((String)downClues.get(i));
        }
    }
}

