/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.presenter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyMapProperty;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.gui.view.model.CrosswordBoxViewModel;
import re.belv.croiseur.gui.view.model.CrosswordGridViewModel;
import re.belv.croiseur.gui.view.model.ErrorsViewModel;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.SolverConfigurationViewModel;
import re.belv.croiseur.gui.view.model.SolverItemViewModel;
import re.belv.croiseur.gui.view.model.SolverProgressViewModel;
import re.belv.croiseur.spi.presenter.solver.SolverDescription;
import re.belv.croiseur.spi.presenter.solver.SolverInitialisationState;
import re.belv.croiseur.spi.presenter.solver.SolverPresenter;
import re.belv.croiseur.spi.presenter.solver.SolverProgress;
import re.belv.croiseur.spi.presenter.solver.SolverResult;

final class GuiSolverPresenter
implements SolverPresenter {
    private static final Logger LOGGER = Logger.getLogger(GuiSolverPresenter.class.getName());
    private final CrosswordGridViewModel crosswordGridViewModel;
    private final SolverConfigurationViewModel solverConfigurationViewModel;
    private final SolverProgressViewModel solverProgressViewModel;
    private final ErrorsViewModel errorsViewModel;

    GuiSolverPresenter(CrosswordGridViewModel crosswordGridViewModelArg, SolverConfigurationViewModel solverConfigurationViewModelArg, SolverProgressViewModel solverProgressViewModelArg, ErrorsViewModel errorsViewModelArg) {
        this.crosswordGridViewModel = crosswordGridViewModelArg;
        this.solverConfigurationViewModel = solverConfigurationViewModelArg;
        this.solverProgressViewModel = solverProgressViewModelArg;
        this.errorsViewModel = errorsViewModelArg;
    }

    public void presentAvailableSolvers(List<SolverDescription> solverDescriptions) {
        LOGGER.info(() -> "Received solver descriptions: " + String.valueOf(solverDescriptions));
        List<SolverItemViewModel> solverNames = solverDescriptions.stream().map(s -> new SolverItemViewModel(s.name(), s.description())).toList();
        Platform.runLater(() -> this.solverConfigurationViewModel.availableSolversProperty().addAll((Collection)solverNames));
    }

    public void presentSolverInitialisationState(SolverInitialisationState solverInitialisationState) {
        LOGGER.info(() -> "Received solver initialisation state: " + String.valueOf(solverInitialisationState));
    }

    public void presentSolverProgress(SolverProgress solverProgress) {
        LOGGER.info(() -> "Received solver progress: " + String.valueOf(solverProgress));
        double normalizedSolverProgress = (double)solverProgress.completionPercentage() / 100.0;
        Platform.runLater(() -> this.solverProgressViewModel.solverProgress(normalizedSolverProgress));
    }

    public void presentSolverResult(SolverResult result) {
        LOGGER.info(() -> "Received solver result: " + String.valueOf(result));
        Platform.runLater(() -> {
            this.updateBoxContent(result);
            this.updateBoxSolvableState(result);
        });
    }

    public void presentSolverError(String error) {
        LOGGER.warning(() -> "Received solver error: " + error);
        Platform.runLater(() -> this.errorsViewModel.addError(error));
    }

    private void updateBoxSolvableState(SolverResult result) {
        ReadOnlyMapProperty viewModelBoxes = this.crosswordGridViewModel.boxesProperty();
        Set unsolvableBoxes = result.unsolvableBoxes();
        for (Map.Entry entry : viewModelBoxes.entrySet()) {
            CrosswordBoxViewModel box = (CrosswordBoxViewModel)entry.getValue();
            if (box.isSelected()) continue;
            GridPosition position = GuiSolverPresenter.gridPositionFrom((GridCoord)entry.getKey());
            box.unsolvableProperty().set(unsolvableBoxes.contains(position));
        }
    }

    private void updateBoxContent(SolverResult result) {
        Map resultBoxes = result.filledBoxes();
        ReadOnlyMapProperty viewModelBoxes = this.crosswordGridViewModel.boxesProperty();
        for (Map.Entry entry : resultBoxes.entrySet()) {
            GridPosition position = (GridPosition)entry.getKey();
            CrosswordBoxViewModel box = (CrosswordBoxViewModel)viewModelBoxes.get(GuiSolverPresenter.gridCoordFrom(position));
            box.solverContent(((Character)entry.getValue()).toString());
        }
    }

    private static GridCoord gridCoordFrom(GridPosition domainPosition) {
        return new GridCoord(domainPosition.x(), domainPosition.y());
    }

    private static GridPosition gridPositionFrom(GridCoord viewModelPosition) {
        return new GridPosition(viewModelPosition.column(), viewModelPosition.row());
    }
}

